/*
 
Vice Multi-Player Functions

(c) Copyright 2005-2017, SA-MP Team & Saint Games

*/

// --------------------------------------------------
// Include File Version "0.1 beta RC 7"
// --------------------------------------------------

#if defined _vmp_included
	#endinput
#endif
#define _vmp_included

#pragma library vmp

#include <core>
#include <float>
#include <string>
#include <file>
#include <time>
#include <datagram>

// --------------------------------------------------
// Defines
// --------------------------------------------------

// Misc
#define MAX_PLAYER_NAME							24
#define MAX_PLAYERS							50
#define MAX_ACTORS							100
#define MAX_VEHICLES							200
#define MAX_PICKUPS							300

#define NO_TEAM								255

#define MAX_OBJECTS							150
#define INVALID_OBJECT_ID						255

#define INVALID_PLAYER_ID						255
#define INVALID_VEHICLE_ID						(0xFF) // (0xFF) = 255 // in SA-MP 0.2X // (0xFFFF)
#define INVALID_ACTOR_ID						255

// States
#define PLAYER_STATE_NONE						0
#define PLAYER_STATE_ONFOOT						1
#define PLAYER_STATE_DRIVER						2
#define PLAYER_STATE_PASSENGER					3
#define PLAYER_STATE_EXIT_VEHICLE					4 // (used internally)
#define PLAYER_STATE_ENTER_VEHICLE_DRIVER				5 // (used internally)
#define PLAYER_STATE_ENTER_VEHICLE_PASSENGER			6 // (used internally)
#define PLAYER_STATE_WASTED						7
#define PLAYER_STATE_SPAWNED						8

// Player Actions Ids // ActionID // for GetPlayerAction(playerid);
#define ACTION_NONE							0 // new from SA-MP
#define ACTION_NORMAL							1 // ON_FOOT
#define ACTION_ONFOOT							1

#define ACTION_WALK							6
//#define ACTION_WALK							7

#define ACTION_FIRST_PERSON_TARGET					12 // ACTION_SCOPE // New Saint Add

#define ACTION_SHOOTING							16 // ACTION_SHOT / ACTION_FIRE // New by Saint Add
#define ACTION_ATTACK_MELEE             				17 //     , , , ,   , 

#define ACTION_RUN_TO_VEHICLE						24 //   

#define ACTION_USECELLPHONE             				36 //

#define ACTION_JUMP                     				41 // 

#define ACTION_IN_VEHICLE						50 // ACTION_DRIVING_VEHICLE / ACTION_INCAR

#define ACTION_DEATH							54 // 
#define ACTION_WASTED							55 //      
#define ACTION_IM_JACKING_VEHICLE					56 //   -     
#define ACTION_ME_JACKING_VEHICLE					57 //   -    
#define ACTION_ENTER_VEHICLE						58 //   

#define ACTION_EXIT_VEHICLE						60 //   
#define ACTION_HANDS_UP							61 // New Saint Add
#define ACTION_BUSTED                   				62 // 

// Vehicles
#define VEHICLE_TYPE_CAR						1
#define VEHICLE_TYPE_BIKE						2
#define VEHICLE_TYPE_HELI						3
#define VEHICLE_TYPE_BOAT						4
#define VEHICLE_TYPE_PLANE						5
#define VEHICLE_TYPE_RC							6 // new

// Weathers
#define WEATHER_SUNNY							0
#define WEATHER_CLOUDY							1
#define WEATHER_RAINING							2
#define WEATHER_FOGGY							3
#define WEATHER_EXTRASUNNY						4
#define WEATHER_STORM							5
#define WEATHER_INTERIOR						6

// Interiors
#define INTERIOR_OUTSIDE						0
#define INTERIOR_STREET							0 // RC 3
#define INTERIOR_HOTEL							1
#define INTERIOR_MANSION						2
#define INTERIOR_BANK							3
#define INTERIOR_MALL							4
#define INTERIOR_STRIPCLUB						5
#define INTERIOR_LAWYERS						6
#define INTERIOR_CAFEROBINA						7
#define INTERIOR_CONCERT						8
#define INTERIOR_STUDIO							9
#define INTERIOR_AMMUNATION						10
#define INTERIOR_APPARTMENT						11
#define INTERIOR_BIKERSBAR						11
#define INTERIOR_POLICEHQ						12
#define INTERIOR_UNKNOWN						12
#define INTERIOR_STADIUM1						14
#define INTERIOR_STADIUM2						15
#define INTERIOR_STADIUM3						16
#define INTERIOR_CLUB							17
#define INTERIOR_PRINTWORKS						18

//--------------------------------------------------------------------------------------------------

// Weapons
#define WEAPON_UNARMED							0
#define WEAPON_BRASSKNUCKLE						1
#define WEAPON_SCREWDRIVER						2   // 
#define WEAPON_GOLFCLUB							3
#define WEAPON_NITESTICK						4
#define WEAPON_KNIFECUR							5
#define WEAPON_BASEBALL_BAT						6
#define WEAPON_HAMMER							7
#define WEAPON_CLEAVER							8
#define WEAPON_MACHETE							9
#define WEAPON_KATANA							10
#define WEAPON_CHAINSAW							11
#define WEAPON_GRENADE							12
#define WEAPON_TEARGAS							14
#define WEAPON_MOLOTOV							15
#define WEAPON_MISSILE							16 //  ()  RPG
#define WEAPON_COLT45							17
#define WEAPON_PYTHON							18
#define WEAPON_CHROMEGUN						19
#define WEAPON_SHOTGSPA							20
#define WEAPON_BUDDYSHOT						21
#define WEAPON_TEC9							22
#define WEAPON_UZI							23
#define WEAPON_INGRAMSL							24
#define WEAPON_MP5LNG							25
#define WEAPON_M4								26
#define WEAPON_RUGER							27
#define WEAPON_SNIPER							28
#define WEAPON_LASER							29
#define WEAPON_ROCKETLA							30
#define WEAPON_FLAME							31
#define WEAPON_M60							32
#define WEAPON_MINIGUN							33
#define WEAPON_BOMB							34 // Detonator
#define WEAPON_HELICANNON						35 // (M60  )
#define WEAPON_CAMERA							36
#define WEAPON_COLLISION						39 // Vehicle ??? //  
#define WEAPON_HELIBLADES						40 // Heli-Blades
#define WEAPON_EXPLOSION						41 // Explosion
#define WEAPON_DRIVEBY							42 // Drive-By // WEAPON_VEHICLE (c    )
#define WEAPON_DROWN							43 // Drown
#define WEAPON_COLLISION_GROUND					44 // Ground collision from VCMP 0.3z R2

#define ICON_CONNECT							200 //
#define ICON_DISCONNECT							201 //

//----------------------------------------------------------------------------------
//==================================================================================
// Vice Multi-Player Keys States
//==================================================================================

// Player ONFOOT Keys // RC 2-9 T3 and ++

#define ONFOOT_KEY_UP				(4096)  // fixed // KEY_ANALOG_UP   (KEY_FORWARD)
#define ONFOOT_KEY_DOWN				(2048)  // fixed // KEY_ANALOG_DOWN (KEY_BACKWARD)
#define ONFOOT_KEY_LEFT				(1024)  // fixed // KEY_ANALOG_LEFT
#define ONFOOT_KEY_RIGHT			(512)   // fixed // KEY_ANALOG_RIGHT

#define ONFOOT_KEY_FIRE				(64)    // fixed

#define ONFOOT_KEY_WEAPON_NEXT		(2)     // fixed // E
#define ONFOOT_KEY_WEAPON_PREVIOUS		(4)     // fixed // Q

//#define ONFOOT_KEY_ZOOM_IN		      (-1)    // not detected
//#define ONFOOT_KEY_ZOOM_OUT		      (-1)    // not detected

//#define ONFOOT_KEY_ENTER+EXIT		(-1)	  // not detected

#define ONFOOT_KEY_JUMP				(256)   // fixed

#define ONFOOT_KEY_SPRINT			(128)   // fixed

#define ONFOOT_KEY_TARGET			(1)     // fixed //  (RPG, M4, M60, Ruger, Sniper, ...)

#define ONFOOT_KEY_CROUCH			(32)    // fixed

//#define ONFOOT_KEY_ACTION			(-1)	  // not detected

//#define ONFOOT_KEY_LOOK_BEHIND		(-1)    // not detected

//-----------------------------------------------------------

// Player INCAR Keys // RC 2-9 T3 and ++

#define INCAR_KEY_UP				(128)   // fixed // KEY_UP
#define INCAR_KEY_DOWN				(256)   // fixed // KEY_DOWN
#define INCAR_KEY_LEFT				(1024)  // fixed // KEY_LEFT 
#define INCAR_KEY_RIGHT				(512)   // fixed // KEY_RIGHT 

#define INCAR_KEY_FIRE				(64)    // fixed

//#define INCAR_KEY_ENTER+EXIT		(-1)	  // not detect

#define INCAR_KEY_HORN				(32)	  // fixed

//#define INCAR_KEY_SUBMISSION		(-1)    // not detect

#define INCAR_KEY_HANDBRAKE			(1)     // fixed //  

#define INCAR_KEY_LEAN_UP			(16) 	  // fixed // Num9
#define INCAR_KEY_LEAN_DOWN			(8)     // fixed // Num6

//--------------------------

#define INCAR_KEY_LOOK_BEHIND			(6)     // fixed //   // Q + E or Num1 + Num2 (if incar)
//#define INCAR_KEY_LOOK_BEHIND		(INCAR_KEY_LOOK_LEFT + INCAR_KEY_LOOK_RIGHT)     // fixed //   // Q + E or Num1 + Num2 (if incar)

#define INCAR_KEY_LOOK_LEFT			(4)     // fixed // Q
#define INCAR_KEY_LOOK_RIGHT			(2)     // fixed // E

//==================================================================================



//==================================================================================
// Forwards (Callback declarations)
//==================================================================================

forward OnIncomingConnection(playerid, ip_address[], port);			// added in RC 2-8-8

forward OnFilterScriptInit(); 							// added // fixed
forward OnFilterScriptExit(); 							// added // fixed

forward OnGameModeInit(); 								// added // fixed
forward OnGameModeExit(); 								// added // fixed

forward OnPlayerConnect(playerid); 							// added // fixed
forward OnPlayerDisconnect(playerid, reason); 					// added // fixed

forward OnPlayerRequestClass(playerid, classid); 				// added // fixed // fix update in RC 2-8-8
forward OnPlayerRequestSpawn(playerid); 						// added // fixed

forward OnPlayerSpawn(playerid); 							// added // fixed // fix update in RC 2-8-8
forward OnPlayerDeath(playerid, killerid, reason); 				// added // fixed // fix update in RC 2-5 (fixed all reason's)

forward OnPlayerStateChange(playerid, newstate, oldstate);			// added // fixed
forward OnPlayerInteriorChange(playerid, newinteriorid, oldinteriorid); // added // fixed

forward OnPlayerKeyStateChange(playerid, newkeys, oldkeys);			// added // fixed

forward OnPlayerEnterVehicle(playerid, vehicleid, ispassenger); 		// added // fixed
forward OnPlayerExitVehicle(playerid, vehicleid); 				// added // fixed

forward OnPlayerUpdate(playerid);							// added // fixed

forward OnPlayerText(playerid, text[]); 						// added // fixed // fix update in RC 2-8-7
forward OnPlayerCommandText(playerid, cmdtext[]); 				// added // fixed

forward OnRconLoginAttempt(ip[], password[], success);			// added // fixed // fix update in RC 2-8-5 // fix update in RC 2-8-7
forward OnRconCommand(cmdtext[]); 							// added // fixed

forward OnPlayerPickUpPickup(playerid, pickupid); 				// added // fixed

forward OnObjectMoved(objectid);							// added in 0.1 beta RC 2-4 // TEST

forward OnVehicleSpawn(vehicleid);							// added + fixed in 0.1 beta RC 2-8
forward OnVehicleDeath(vehicleid, killerid);					// added + fixed in 0.1 beta RC 2-8
forward OnVehicleDamageStatusUpdate(vehicleid, playerid);			// added in 0.1 beta RC 2-8-7 // test

forward OnVehicleRespray(playerid, vehicleid, color1, color2);		// added in 0.1 beta RC 2-9 T4 // from SA-MP 0.2x

forward OnPlayerEnterCheckpoint(playerid);					// added + fixed in 0.1 beta RC 2-7
forward OnPlayerLeaveCheckpoint(playerid);					// added + fixed in 0.1 beta RC 2-7

forward OnPlayerEnterRaceCheckpoint(playerid);					// added in 0.1 beta RC 3
forward OnPlayerLeaveRaceCheckpoint(playerid);					// added in 0.1 beta RC 3

forward OnActorDeath(actorid, killerid, reason, bodypart);			// RC 7

//==================================================================================
// Natives
//==================================================================================

//----------------------------------------------------------------------------------

// Util Functions

//----------------------------------------------------------------------------------

native print(const string[]);									// fixed
native printf(const format[], {Float,_}:...);						// fixed
native format(output[], len, const format[], {Float,_}:...);			// fixed

//----------------------------------------------------------------------------------

native CallRemoteFunction(const function[], const format[], {Float,_}:...);	// RC 3
native CallLocalFunction(const function[], const format[], {Float,_}:...);	// RC 3

//----------------------------------------------------------------------------------

native SendClientMessage(playerid, color, const format[]);				// fixed
native SendClientMessageToAll(color, const format[]);					// fixed

//----------------------------------------------------------------------------------

native SendDeathMessage(killer, killee, weapon);					// added in 0.1 beta RC 2-8 // RC 3 Update
native SendDeathMessageToPlayer(playerid, killer, killee, weapon);		// added in 0.1 bera RC 3

//----------------------------------------------------------------------------------

native SendPlayerMessageToPlayer(playerid, senderid, const message[]);		// added in 0.1 beta RC 2-8-7 // TEST // http://wiki.sa-mp.com/wiki/SendPlayerMessageToPlayer
native SendPlayerMessageToAll(senderid, const message[]);				// added in 0.1 beta RC 2-8-7 // TEST // http://wiki.sa-mp.com/wiki/SendPlayerMessageToAll

//----------------------------------------------------------------------------------

native GameTextForPlayer(playerid, const string[], time, style);			// added in 0.1 beta RC 2-8-7 // TEST // http://wiki.sa-mp.com/wiki/GameTextForPlayer
native GameTextForAll(const string[], time, style);					// added in 0.1 beta RC 2-8-7 // TEST // http://wiki.sa-mp.com/wiki/GameTextForAll

//----------------------------------------------------------------------------------

native SetTimer(funcname[], interval, repeating);				            // fixed
native SetTimerEx(funcname[], interval, repeating, const format[], {Float,_}:...);	// fixed
native KillTimer(timerid); 								    		// fixed

//----------------------------------------------------------------------------------

native GetTickCount(); 			// added in 0.1 beta RC 2-4 // 

native GetMaxPlayers(); 		// added in 0.1 beta RC 2-4 //

native GetPlayerPoolSize(); // RC 7

native GetVehiclePoolSize(); // RC 7

//----------------------------------------------------------------------------------

native Float:asin(Float:value);							    // fixed
native Float:acos(Float:value);							    // fixed
native Float:atan(Float:value); 							    // fixed
native Float:atan2(Float:x, Float:y); 						    // fixed

//----------------------------------------------------------------------------------

// Game Functions

//----------------------------------------------------------------------------------

native GameModeExit();				// added + fixed
native SetGameModeText(const string[]); 	// added + fixed

native SetTeamCount(count); 			// none

//----------------------------------------------------------------------------------

native AddPlayerClass(modelid, Float:spawn_x, Float:spawn_y, Float:spawn_z, Float:z_angle, weapon1, weapon1_ammo, weapon2, weapon2_ammo, weapon3, weapon3_ammo); // added + fixed
native AddPlayerClassEx(teamid, modelid, Float:spawn_x, Float:spawn_y, Float:spawn_z, Float:z_angle, weapon1, weapon1_ammo, weapon2, weapon2_ammo, weapon3, weapon3_ammo); // added + fixed

//----------------------------------------------------------------------------------

native AddStaticVehicle(modelid, Float:spawn_x, Float:spawn_y, Float:spawn_z, Float:z_angle, color1, color2); // fixed in 0.1 beta RC 2-8
native AddStaticVehicleEx(modelid, Float:spawn_x, Float:spawn_y, Float:spawn_z, Float:z_angle, color1, color2, respawn_delay); // fixed in 0.1 beta RC 2-8

//----------------------------------------------------------------------------------

// Virtual Worlds // added in 0.1 beta RC 3

native GetPlayerVirtualWorld(playerid);			// RC 3 // RC 4-2 T5 Update
native SetPlayerVirtualWorld(playerid, worldid);	// RC 3 // RC 4-2 T5 Update

native GetVehicleVirtualWorld(vehicleid);			// RC 3 // RC 4-2 T5 Update
native SetVehicleVirtualWorld(vehicleid, worldid);	// RC 3 // RC 4-2 T5 Update

//----------------------------------------------------------------------------------

native AddStaticPickup(model, type, Float:X, Float:Y, Float:Z);   // added + fixed
native CreatePickup(model, type, Float:X, Float:Y, Float:Z);	// added + fixed
native DestroyPickup(pickup);							// added + fixed

native TogglePickupArrow(pickupid, toggle);				// RC 2-9 // RC 4-2 T4 Update
native TogglePickupArrowForPlayer(playerid, pickupid, toggle);	// RC 4-2 T4 // RC 5-2 T8 fix // RC 6

//----------------------------------------------------------------------------------

native CreateExplosion(type, Float:X, Float:Y, Float:Z);				// added + fixed in 0.1 beta RC 2-3
native CreateExplosionForPlayer(playerid, Float:X, Float:Y, Float:Z, type);	// added in 0.1 beta RC 2-8-8 (T3)

//----------------------------------------------------------------------------------

// Object's functions (from SA-MP 0.2x) added in 0.1 beta RC 2-4

native CreateObject(modelid, Float:X, Float:Y, Float:Z, Float:rX, Float:rY, Float:rZ); 	// added in 0.1 beta RC 2-4 // fixed
native IsValidObject(objectid); 										// added in 0.1 beta RC 2-4 // fixed
native DestroyObject(objectid); 										// added in 0.1 beta RC 2-4 // fixed

native GetObjectPos(objectid, &Float:X, &Float:Y, &Float:Z); 					// added in 0.1 beta RC 2-4 // ?????
native SetObjectPos(objectid, Float:X, Float:Y, Float:Z);	 					// added in 0.1 beta RC 2-4 // fixed

native GetObjectRot(objectid, &Float:RotX, &Float:RotY, &Float:RotZ); 				// added in 0.1 beta RC 2-4 // ?????
native SetObjectRot(objectid, Float:RotX, Float:RotY, Float:RotZ);    				// added in 0.1 beta RC 2-4 // fixed

native MoveObject(objectid, Float:X, Float:Y, Float:Z, Float:Speed);  				// added in 0.1 beta RC 2-4 // fix update in 0.1 beta RC 2-8-7
native StopObject(objectid); 											// added in 0.1 beta RC 2-4 // fixed

native ToggleObjectCollision(objectid, toggle);	 							// added in 0.1 beta RC 2-4 // test
native ToggleObjectMoving(objectid, toggle);								// RC 5 T1

native ToggleObjectArrow(objectid, toggle);								// added in 0.1 beta RC 2-9 // test
native ToggleObjectArrowForPlayer(playerid, objectid, toggle);					// added in 0.1 beta RC 2-9 // test

native AttachObjectToVehicle(objectid, vehicleid, Float:OffsetX, Float:OffsetY, Float:OffsetZ); // RC 4-2 T3

// Object's functions // End

//----------------------------------------------------------------------------------

// Text Draw functions from SA-MP 0.2x // for Server Added in RC 2-9 // RC 3 // for Client not fixed

native Text:TextDrawCreate(Float:x, Float:y, text[]);
native TextDrawDestroy(Text:text);

native TextDrawSetString(Text:text, string[]);

native TextDrawLetterSize(Text:text, Float:x, Float:y);
native TextDrawTextSize(Text:text, Float:x, Float:y);
native TextDrawAlignment(Text:text, alignment);
native TextDrawColor(Text:text, color);
native TextDrawUseBox(Text:text, use);
native TextDrawBoxColor(Text:text, color);
native TextDrawSetShadow(Text:text, size);
native TextDrawSetOutline(Text:text, size);
native TextDrawBackgroundColor(Text:text, color);
native TextDrawFont(Text:text, font);
native TextDrawSetProportional(Text:text, set);
native TextDrawShowForPlayer(playerid, Text:text);
native TextDrawHideForPlayer(playerid, Text:text);
native TextDrawShowForAll(Text:text);
native TextDrawHideForAll(Text:text);

// Text Draw functions from SA-MP 0.2x // for Server Added in RC 2-9 // RC 3 // for Client not fixed

//----------------------------------------------------------------------------------

native ShowPlayerMarkers(mode); 		// added + fixed

native ShowVehicleMarkers(bool);		// RC 7

native ToggleFriendlyFire(toggle);		// RC 2-9 T3 //   "SetPlayerFriendlyFire" from VC-MP 0.3z_r2 

native ToggleDeathDropWeapons(toggle);	// RC 2-9-2 T4

//----------------------------------------------------------------------------------
	
native GetGravity();				// added
native SetGravity(Float:gravity);		// added

//----------------------------------------------------------------------------------

native GetWaterLevel();				// added
native SetWaterLevel(Float:waterlevel);	// added

//----------------------------------------------------------------------------------

native GetMaxHeliHeightLevel();		 // added
native SetMaxHeliHeightLevel(Float:level); // added

//----------------------------------------------------------------------------------

native SetWorldTime(hour, minute);		// added
native SetWeather(weatherid); 		// added

//----------------------------------------------------------------------------------

native GetWeaponName(weaponid, const weapon[], len); // added in 0.1 beta RC 2-8

//----------------------------------------------------------------------------------

// Vehicle Functions // a_vehicles.inc //

//----------------------------------------------------------------------------------

native CreateVehicle(vehicletype, Float:x, Float:y, Float:z, Float:rotation, color1, color2, respawn_delay); // added in 0.1 beta RC 2-8
native DestroyVehicle(vehicleid); // added in 0.1 beta RC 2-8 // RC 3 Update

native IsValidVehicle(vehicleid);						// fixed

native GetVehicleModel(vehicleid);						// fixed

native SetVehicleToRespawn(vehicleid);					// added in 0.1 beta RC 2-8-2 (RC 2-8-4) // fixed

native GetVehicleHealth(vehicleid, &Float:health);			// fixed
native SetVehicleHealth(vehicleid, Float:health);			// fixed

native RepairVehicleModel(vehicleid);					// added in 0.1 beta RC 2-5 // fixed

native ChangeVehicleColor(vehicleid, color1, color2);			// added // fixed

native KillVehicleEngine(vehicleid);					// added in 0.1 beta RC 2-4 //   VC-MP 0.3z R2

native SetVehicleFreezePosState(vehicleid, bool);			// RC 5-2 T10 // RC 6

native BlowUpVehicle(vehicleid);						// RC 4-2 T3

native OpenVehicleTrunk(vehicleid);						// fixed

native ToggleVehicleTaxiLight(vehicleid, toggle);			// fixed

native SetVehicleDoorsStatus(vehicleid, bool);				// RC 2-5 // fixed
native SetVehicleLightsStatus(vehicleid, bool);				// RC 2-5 // fixed

native GetVehicleTiresStatus(vehicleid, &tire_fl, &tire_fr, &tire_rl, &tire_rr); // RC 2-8-9 test // RC 2-9-2 fix
native SetVehicleTiresStatus(vehicleid, bool);				// RC 2-5 // fixed

native SetVehicleEnableAlarm(vehicleid, time);				// RC 3 // time 10000 = 10 sek //  SetVehicleAlarm from vcmp 0.3z r2 

native ToggleVehicleArrow(vehicleid, toggle);				// RC 2-9 T2// RC 3 T2 fix Update
native ToggleVehicleArrowForPlayer(playerid, vehicleid, toggle);	// RC 2-9 T2 // RC 3 T2 fix Update

native GetVehiclePos(vehicleid, &Float:x, &Float:y, &Float:z); 	// fixed
native SetVehiclePos(vehicleid, Float:x, Float:y, Float:z); 	// fixed in 0.1 beta RC 2-6

native GetVehicleZAngle(vehicleid, &Float:z_angle);			// fixed
native SetVehicleZAngle(vehicleid, Float:z_angle);			// added in 0.1 beta RC 2-4 // test

native GetPlayerVelocity(playerid, &Float:X, &Float:Y, &Float:Z);	// added in 0.1 beta RC 2-8-7 TEST //   SA-MP 0.3a  
native SetPlayerVelocity(playerid, Float:X, Float:Y, Float:Z);	// added in 0.1 beta RC 2-8-7 TEST //   SA-MP 0.3a  

native GetVehicleVelocity(vehicleid, &Float:X, &Float:Y, &Float:Z);  // added in 0.1 beta RC 2-7 TEST //   SA-MP 0.3a  
native SetVehicleVelocity(vehicleid, Float:X, Float:Y, Float:Z);	   // added in 0.1 beta RC 2-7 TEST //   SA-MP 0.3a  

//---------------------------------------------------------------------------------

// Admin Functions

//---------------------------------------------------------------------------------

native IsPlayerAdmin(playerid);						// added // fixed
native Kick(playerid); 								// added // ?????
native Ban(playerid);								// added // ?????
native BanEx(playerid, const reason[]);					// added // ?????
native BanIP(const ip[]);							// added // ?????
native SendRconCommand(command[]);						// added // fixed

native GetServerVarAsString(const varname[], buffer[], len);	// added in 0.1 beta RC 2-8-5 // http://wiki.sa-mp.com/wiki/GetServerVarAsString
native GetServerVarAsInt(const varname[]);				// added in 0.1 beta RC 2-8-5 // http://wiki.sa-mp.com/wiki/GetServerVarAsInt
native GetServerVarAsBool(const varname[]);				// added in 0.1 beta RC 2-8-5 // http://wiki.sa-mp.com/wiki/GetServerVarAsBool

//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------

// Player Functions // a_players.inc //

//---------------------------------------------------------------------------------

native IsPlayerConnected(playerid); 					// added // fixed
//---------------------------------------------------------------------------------
native GetPlayerIp(playerid, const name[], len); 			// added // fixed
native GetPlayerPing(playerid); 						// added // fixed
//---------------------------------------------------------------------------------
native GetPlayerName(playerid, const name[], len); 			// added // fixed
native SetPlayerName(playerid, const name[]);				// added // fixed
//---------------------------------------------------------------------------------
native GetPlayerScore(playerid);						// added // fixed
native SetPlayerScore(playerid, score);					// added // fixed
//---------------------------------------------------------------------------------

native GetPlayerMoney(playerid); 						// added // fixed // re-fixed in 0.1 beta RC 2-8
native SetPlayerMoney(playerid, money); 					// added // fixed //  SA-MP       (.pwn)
native GivePlayerMoney(playerid, money); 					// added // fixed
native ResetPlayerMoney(playerid);						// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerTeam(playerid);						// added // ?????
native SetPlayerTeam(playerid, teamid);					// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerColor(playerid); // added in RC 2-8-8 // test
native SetPlayerColor(playerid, color); // added in RC 2-8-8 // test

//---------------------------------------------------------------------------------

native SetPlayerMarkerForPlayer(playerid, showplayerid, color); // added in RC 2-8-9 // test

native RemovePlayerMarker(playerid); // from VC-MP 0.3z_r2 // added in RC 2-9-3 T1 // test // fixed

//---------------------------------------------------------------------------------

native GetPlayerInterior(playerid);						// added // fixed
native SetPlayerInterior(playerid, interiorid);				// added // fixed

//---------------------------------------------------------------------------------

// http://wiki.sa-mp.com/wiki/SetPlayerWorldBounds
native SetPlayerWorldBounds(playerid, Float:x_max, Float:x_min, Float:y_max, Float:y_min); // added in 0.1 beta RC 2-8-5

//---------------------------------------------------------------------------------

native SetSpawnInfo(playerid, team, skin, Float:x, Float:y, Float:z, Float:rotation, weapon1, weapon1_ammo, weapon2, weapon2_ammo, weapon3, weapon3_ammo); // added in 0.1 beta RC 2-9-2 // test

native SpawnPlayer(playerid); 						// added in 0.1 beta RC 2-8 // test

native ForceClassSelection(playerid);					// added in 0.1 beta RC 2-8-8 // test

//---------------------------------------------------------------------------------

native GetPlayerPos(playerid, &Float:x, &Float:y, &Float:z);	// added // fixed
native SetPlayerPos(playerid, Float:x, Float:y, Float:z);		// added // fixed // fix update in RC 2-8-8 (now work in OnPlayerRequestClass)
native SetPlayerPosFindZ(playerid, Float:x, Float:y, Float:z);	// added // ?????

//---------------------------------------------------------------------------------

native IsPlayerInRangeOfPoint(playerid, Float:range, Float:x, Float:y, Float:z); // added // fixed // from SA-MP 0.3a

//---------------------------------------------------------------------------------

native GetPlayerFacingAngle(playerid, &Float:ang);			// added // fixed
native SetPlayerFacingAngle(playerid, Float:ang);			// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerSkin(playerid);						// added // fixed
native SetPlayerSkin(playerid, skinid);					// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerHealth(playerid, &Float:health); 			// added // fixed
native SetPlayerHealth(playerid, Float:health); 			// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerArmour(playerid, &Float:armour); 			// added // fixed
native SetPlayerArmour(playerid, Float:armour); 			// added // fixed

//---------------------------------------------------------------------------------

native GetPlayerWantedLevel(playerid);					// added // fixed // + fix update in RC 2-8-9
native SetPlayerWantedLevel(playerid, level); 				// added // fixed in 0.1 beta RC 2-8-4

//---------------------------------------------------------------------------------

native GetPlayerGravity(playerid, &Float:gravity);			// RC 2-9 T3 // test
native GetPlayerWaterLevel(playerid, &Float:level);			// RC 2-9 T3 // test
native GetPlayerMaxHeliHeightLevel(playerid, &Float:level);		// RC 2-9 T3 // test

//---------------------------------------------------------------------------------

native SetPlayerDriveOnWater(playerid, toggle); 			// added // fixed

native EnableStuntBikeForPlayer(playerid, toggle);			// RC 2-9 //   // http://thijn.vrocker-hosting.co.uk/VCWiki/index.php/EnableStuntBike

native SetPlayerInfiniteRun(playerid, toggle);				// added // fixed

native SetPlayerWeather(playerid, weatherid); 				// added // fixed

native SetPlayerDrunk(playerid, visuals, handling); 			// added RC 2 // fixed //   VC-MP 0.3z R2 // http://thijn.vrocker-hosting.co.uk/VCWiki/index.php/SetPlayerDrunk

native TogglePlayerControllable(playerid, toggle);			// added // fixed

native TogglePlayerBleeding(playerid, toggle);				// added + fixed in 0.1 beta RC 2-5

native TogglePlayerCellPhone(playerid, toggle);				// added // fixed in 0.1 beta RC 2-5

native TogglePlayerWhiteScanlines(playerid, toggle);			// added // fixed
native TogglePlayerGreenScanlines(playerid, toggle);			// added // fixed
native TogglePlayerWidescreen(playerid, toggle);			// added // fixed

//---------------------------------------------------------------------------------

#define MAPICON_LOCAL			  0 // displays in the player's local are
#define MAPICON_GLOBAL			  1 // displays always
#define MAPICON_LOCAL_CHECKPOINT  2 // displays in the player's local area and has a checkpoint marker
#define MAPICON_GLOBAL_CHECKPOINT 3 // displays always and has a checkpoint marker

native SetPlayerMapIcon(playerid, iconid, Float:x, Float:y, Float:z, markertype, color, style = MAPICON_LOCAL);	// added + fixed in 0.1 beta RC 2-4 // RC 2-8-8 update
native RemovePlayerMapIcon(playerid, iconid);												// added // fix update in 0.1 beta RC 2-7

//---------------------------------------------------------------------------------

native GetPlayerState(playerid); 						// added // fix update in 0.1 beta RC 2-5

native GetPlayerAction(playerid);	// RC 2-8-9 test

//---------------------------------------------------------------------------------

native IsPlayerInVehicle(playerid, vehicleid);				// added // fixed
native IsPlayerInAnyVehicle(playerid);					// added // fixed
native GetPlayerVehicleID(playerid);					// added // fixed

native GetPlayerVehicleSeat(playerid); // from SA-MP 0.3a 		// added in 0.1 beta RC 2-8-6 // TEST

//---------------------------------------------------------------------------------

native PutPlayerInVehicle(playerid, vehicleid, seatid);				// added in 0.1 beta RC 2-4 // fixed // RC 2-9-4 fix update
native RemovePlayerFromVehicle(playerid);							// added in 0.1 beta RC 2-4 // fixed
native RemovePlayerFromVehicleAndPutAt(playerid, Float:x, Float:y, Float:z);	// added in 0.1 beta RC 2-4 // fixed

//---------------------------------------------------------------------------------

native ResetPlayerWeapons(playerid);					// added // fixed // Re-Create in 0.1 beta RC 2-8
native GetPlayerWeapon(playerid);						// added // fixed
native GivePlayerWeapon(playerid, weaponid, ammo);			// added // fixed // Re-Create in 0.1 beta RC 2-8 

native SetPlayerArmedWeapon(playerid, weaponid);			// added // fixed // Re-Create in 0.1 beta RC 2-8 // now can change if PLAYER_STATE_DRIVER

native GetPlayerWeaponData(playerid, slot, &weapon, &ammo);		// added // fix update in RC 3

native GetPlayerAmmo(playerid);						// added in 0.1 beta RC 2-8-5 // fix update in RC 2-9
native SetPlayerAmmo(playerid, weaponslot, ammo);			// added in 0.1 beta RC 2-8-5 // fix update in RC 3

//---------------------------------------------------------------------------------

native PlayerPlaySound(playerid, soundid, Float:x, Float:y, Float:z); // added // fixed //   SA-MP
native PlayerPlayMusic(playerid, musicid);				    // added // fixed // new by Saint

native PlayAudioStreamForPlayer(playerid, url[], Float:posX = 0.0, Float:posY = 0.0, Float:posZ = 0.0, Float:distance = 50.0, usepos = 0);
native StopAudioStreamForPlayer(playerid);

//---------------------------------------------------------------------------------

native GetPlayerWaitState(playerid); // RC 7
native SetPlayerWaitState(playerid, stateid, time); // opcode 0372 // added in 0.1 beta RC 2-8-6 // RC 7 T1 Fix

native ApplyPlayerAnimation(playerid, animgroupid, animid, Float:blend); // 0.1 beta RC 5-2 // RC 6 // RC 7 T1 Fix

//---------------------------------------------------------------------------------

#define CAMERA_MOVE	1
#define CAMERA_CUT	2

native SetPlayerCameraPos(playerid, Float:x, Float:y, Float:z); 	    				// added // fixed //   SA-MP
native SetPlayerCameraLookAt(playerid, Float:x, Float:y, Float:z, cut = CAMERA_CUT);	// added // fixed //   SA-MP 0.3d  
native SetCameraBehindPlayer(playerid);					    				// added // fixed //   SA-MP

native GetPlayerCameraMode(playerid); // from SA-MP 0.3c R3 // added in 0.1 beta RC 2-8-6

//---------------------------------------------------------------------------------

native SetPlayerCheckpoint(playerid, Float:x, Float:y, Float:z, Float:size, r = 252, g = 138, b = 242);	// added in 0.1 beta RC 2-7 // RC 4 update
native DisablePlayerCheckpoint(playerid);							// added in 0.1 beta RC 2-7 // TEST
native IsPlayerInCheckpoint(playerid);							// added in 0.1 beta RC 2-7 // TEST

native SetPlayerRaceCheckpoint(playerid, type, Float:size, Float:x, Float:y, Float:z, r = 252, g = 138, b = 242); // RC 3 // RC 4 update //    SA-MP 
native DisablePlayerRaceCheckpoint(playerid); // RC 3
native IsPlayerInRaceCheckpoint(playerid); // RC 3

//---------------------------------------------------------------------------------

native GetPlayerVehicleWeaponRot(playerid, &Float:x, &Float:y); // RC 2-8-9 test

//---------------------------------------------------------------------------------

native IsPlayerInWater(playerid); // RC 7

//====================================================================================

// Spectating // added in 0.1 beta RC 2-9-3 T2

#define SPECTATE_MODE_NORMAL		1
#define SPECTATE_MODE_FIXED		2
#define SPECTATE_MODE_SIDE		3

native TogglePlayerSpectating(playerid, toggle);
native PlayerSpectatePlayer(playerid, targetplayerid, mode = SPECTATE_MODE_NORMAL);
native PlayerSpectateVehicle(playerid, targetvehicleid, mode = SPECTATE_MODE_NORMAL);

//====================================================================================

	// Vice Multi-Player Actor Functions // added in RC 2-9-2 and ++;

native CreateActor(modelid, Float:X, Float:Y, Float:Z, Float:Rotation); // RC 2-9-2 T1
native DestroyActor(actorid); 

native IsValidActor(actorid);

native GetActorVirtualWorld(actorid);		// RC 3 // RC 4-2 T5 Update
native SetActorVirtualWorld(actorid, vworld);	// RC 3 // RC 4-2 T5 Update

native GetActorPos(actorid, &Float:X, &Float:Y, &Float:Z);
native SetActorPos(actorid, Float:X, Float:Y, Float:Z);
native GetActorFacingAngle(actorid, &Float:ang);
native SetActorFacingAngle(actorid, Float:ang);

native GetActorHealth(actorid, &Float:health); // RC 2-9-2 T4
native SetActorHealth(actorid, Float:health); // RC 2-9-2 T4

native SetActorInvulnerable(actorid, invulnerable = true); // RC 2-9-2 T5
native IsActorInvulnerable(actorid); // RC 2-9-2 T5

#define ACTOR_MOVE_TYPE_WALK		0 // RC 2-9-3 // fixed
#define ACTOR_MOVE_TYPE_RUN		1 // RC 2-9-3 // fixed
#define ACTOR_MOVE_TYPE_SPRINT	2 // RC 2-9-3 // not fixed

native ActorMoveTo(actorid, movetype, Float:X, Float:Y, Float:Z ); // only for test // RC 2-9-3 "movetype" update

native SetActorWeapon(actorid, weaponid); // RC 3 // only for test

native ToggleActorBleeding(actorid, toggle); // RC 3 // only for test

native ToggleActorArrow(actorid, toggle); // RC 3 // only for test
native ToggleActorArrowForPlayer(playerid, actorid, toggle); // RC 3 // only for test

native SetActorWaitState(actorid, stateid, time); // RC 5-2 T10 // RC 6 T1 // RC 7 T1 Fix
native ApplyActorAnimation(actorid, animgroupid, animid, Float:blend); // RC 5-2 T10 // RC 7 T1 Fix

native PutActorInVehicle(actorid, vehicleid, seatid); // RC 3 // only for test
native RemoveActorFromVehicleAndPutAt(actorid, Float:x, Float:y, Float:z); // RC 3 // only for test

native ActorExitFromCurrentVehicle(actorid); // RC 3 // only for test

//====================================================================================


